<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Menu Clean</title>

    <!-- Tailwind -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50">

    <!-- HEADER -->
    <header class="w-full bg-white shadow-md py-4 px-6 flex items-center justify-between fixed top-0 left-0 z-50">

        <!-- LOGO -->
        <div class="flex items-center gap-3">
            <i class="fa-solid fa-bars text-2xl text-gray-700 cursor-pointer" id="btnMenu"></i>
            <span class="text-xl font-semibold text-gray-800 tracking-tight">Painel Clean</span>
        </div>

        <!-- ÍCONES DA DIREITA -->
        <div class="flex items-center gap-6">
            <i class="fa-regular fa-bell text-xl text-gray-600 cursor-pointer"></i>
            <i class="fa-solid fa-circle-user text-2xl text-gray-600 cursor-pointer"></i>
        </div>
    </header>

    <!-- MENU LATERAL -->
    <aside id="menuLateral"
        class="fixed top-0 left-0 w-64 h-full bg-white shadow-xl transform -translate-x-full transition-all duration-300 z-40">

        <div class="p-6 flex items-center justify-between border-b">
            <span class="text-lg font-semibold text-gray-700">Menu</span>
            <i class="fa-solid fa-xmark text-xl cursor-pointer" id="closeMenu"></i>
        </div>

        <nav class="p-4 flex flex-col gap-3">
            <a href="#" class="p-3 rounded-xl bg-gray-100 text-gray-700 hover:bg-gray-200 transition">
                <i class="fa-solid fa-house mr-2"></i> Dashboard
            </a>

            <a href="#" class="p-3 rounded-xl bg-gray-100 text-gray-700 hover:bg-gray-200 transition">
                <i class="fa-solid fa-box mr-2"></i> Pedidos
            </a>

            <a href="#" class="p-3 rounded-xl bg-gray-100 text-gray-700 hover:bg-gray-200 transition">
                <i class="fa-solid fa-users mr-2"></i> Clientes
            </a>

            <a href="#" class="p-3 rounded-xl bg-gray-100 text-gray-700 hover:bg-gray-200 transition">
                <i class="fa-solid fa-gear mr-2"></i> Configurações
            </a>
        </nav>
    </aside>

    <script>
        const btnMenu = document.getElementById("btnMenu");
        const closeMenu = document.getElementById("closeMenu");
        const menu = document.getElementById("menuLateral");

        btnMenu.onclick = () => menu.classList.remove("-translate-x-full");
        closeMenu.onclick = () => menu.classList.add("-translate-x-full");
    </script>

</body>
</html>